/*
Copyright (C) 2002-2009 Rice1964

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

void RSP_GBI1_Vtx(Gfx *gfx)
{
	uint32 addr = RSPSegmentAddr((gfx->gbi1vtx.addr));
	uint32 v0  = gfx->gbi1vtx.v0;
	uint32 n   = gfx->gbi1vtx.n;

	LOG_UCODE("    Address 0x%08x, v0: %d, Num: %d, Length: 0x%04x", addr, v0, n, gfx->gbi1vtx.len);

	if (addr > g_dwRamSize)
	{
		TRACE0("     Address out of range - ignoring load");
		return;
	}

	if ((v0 + n) > 80)
	{
		TRACE5("Warning, invalid vertex positions, N=%d, v0=%d, Addr=0x%08X, Cmd=%08X-%08X",
			n, v0, addr, gfx->words.w0, gfx->words.w1);
		return;
	}

	ProcessVertexData(addr, v0, n);
	status.dwNumVertices += n;
	DisplayVertexInfo(addr, v0, n);
}

void RSP_GBI1_ModifyVtx(Gfx *gfx)
{
	SP_Timing(RSP_GBI1_ModifyVtx);

	if( gRSP.ucode == 5 && ((gfx->words.w0)&0x00FFFFFF) == 0 && ((gfx->words.w1)&0xFF000000) == 0x80000000 )
	{
		DLParser_Bomberman2TextRect(gfx);
	}
	else
	{
		uint32 dwWhere = ((gfx->words.w0) >> 16) & 0xFF;
		uint32 dwVert   = (((gfx->words.w0)      ) & 0xFFFF) / 2;
		uint32 dwValue  = (gfx->words.w1);

		if( dwVert > 80 )
		{
			RSP_RDP_NOIMPL("RSP_GBI1_ModifyVtx: Invalid vertex number: %d", dwVert, 0);
			return;
		}

		// Data for other commands?
		switch (dwWhere)
		{
		case RSP_MV_WORD_OFFSET_POINT_RGBA:			// Modify RGBA
		case RSP_MV_WORD_OFFSET_POINT_XYSCREEN:		// Modify X,Y
		case RSP_MV_WORD_OFFSET_POINT_ZSCREEN:		// Modify C
		case RSP_MV_WORD_OFFSET_POINT_ST:			// Texture
			ModifyVertexInfo(dwWhere, dwVert, dwValue);
			break;
		default:
			RSP_RDP_NOIMPL("RSP_GBI1_ModifyVtx: Setting unk value: 0x%02x, 0x%08x", dwWhere, dwValue);
			break;
		}
	}
}

// CODE MODIFICATION
extern int currentTrack;
long i = 0, j = 40, k = 0, count = 0;
uint32 rainbow[] = { 0xFFFF0000, 0xFFFF0100, 0xFFFF0200, 0xFFFF0300, 0xFFFF0400, 0xFFFF0500, 0xFFFF0600, 0xFFFF0700, 0xFFFF0800, 0xFFFF0900, 0xFFFF0A00, 0xFFFF0B00, 0xFFFF0C00, 0xFFFF0D00, 0xFFFF0E00, 0xFFFF0F00, 0xFFFF1000, 0xFFFF1100, 0xFFFF1200, 0xFFFF1300, 0xFFFF1400, 0xFFFF1500, 0xFFFF1600, 0xFFFF1700, 0xFFFF1800, 0xFFFF1900, 0xFFFF1A00, 0xFFFF1B00, 0xFFFF1C00, 0xFFFF1D00, 0xFFFF1E00, 0xFFFF1F00, 0xFFFF2000, 0xFFFF2100, 0xFFFF2200, 0xFFFF2300, 0xFFFF2400, 0xFFFF2500, 0xFFFF2600, 0xFFFF2700, 0xFFFF2800, 0xFFFF2900, 0xFFFF2A00, 0xFFFF2B00, 0xFFFF2C00, 0xFFFF2D00, 0xFFFF2E00, 0xFFFF2F00, 0xFFFF3000, 0xFFFF3100, 0xFFFF3200, 0xFFFF3300, 0xFFFF3400, 0xFFFF3500, 0xFFFF3600, 0xFFFF3700, 0xFFFF3800, 0xFFFF3900, 0xFFFF3A00, 0xFFFF3B00, 0xFFFF3C00, 0xFFFF3D00, 0xFFFF3E00, 0xFFFF3F00, 0xFFFF4000, 0xFFFF4100, 0xFFFF4200, 0xFFFF4300, 0xFFFF4400, 0xFFFF4500, 0xFFFF4600, 0xFFFF4700, 0xFFFF4800, 0xFFFF4900, 0xFFFF4A00, 0xFFFF4B00, 0xFFFF4C00, 0xFFFF4D00, 0xFFFF4E00, 0xFFFF4F00, 0xFFFF5000, 0xFFFF5100, 0xFFFF5200, 0xFFFF5300, 0xFFFF5400, 0xFFFF5500, 0xFFFF5600, 0xFFFF5700, 0xFFFF5800, 0xFFFF5900, 0xFFFF5A00, 0xFFFF5B00, 0xFFFF5C00, 0xFFFF5D00, 0xFFFF5E00, 0xFFFF5F00, 0xFFFF6000, 0xFFFF6100, 0xFFFF6200, 0xFFFF6300, 0xFFFF6400, 0xFFFF6500, 0xFFFF6600, 0xFFFF6700, 0xFFFF6800, 0xFFFF6900, 0xFFFF6A00, 0xFFFF6B00, 0xFFFF6C00, 0xFFFF6D00, 0xFFFF6E00, 0xFFFF6F00, 0xFFFF7000, 0xFFFF7100, 0xFFFF7200, 0xFFFF7300, 0xFFFF7400, 0xFFFF7500, 0xFFFF7600, 0xFFFF7700, 0xFFFF7800, 0xFFFF7900, 0xFFFF7A00, 0xFFFF7B00, 0xFFFF7C00, 0xFFFF7D00, 0xFFFF7E00, 0xFFFF7F00, 0xFFFF8000, 0xFFFF8100, 0xFFFF8200, 0xFFFF8300, 0xFFFF8400, 0xFFFF8500, 0xFFFF8600, 0xFFFF8700, 0xFFFF8800, 0xFFFF8900, 0xFFFF8A00, 0xFFFF8B00, 0xFFFF8C00, 0xFFFF8D00, 0xFFFF8E00, 0xFFFF8F00, 0xFFFF9000, 0xFFFF9100, 0xFFFF9200, 0xFFFF9300, 0xFFFF9400, 0xFFFF9500, 0xFFFF9600, 0xFFFF9700, 0xFFFF9800, 0xFFFF9900, 0xFFFF9A00, 0xFFFF9B00, 0xFFFF9C00, 0xFFFF9D00, 0xFFFF9E00, 0xFFFF9F00, 0xFFFFA000, 0xFFFFA100, 0xFFFFA200, 0xFFFFA300, 0xFFFFA400, 0xFFFFA500, 0xFFFFA600, 0xFFFFA700, 0xFFFFA800, 0xFFFFA900, 0xFFFFAA00, 0xFFFFAB00, 0xFFFFAC00, 0xFFFFAD00, 0xFFFFAE00, 0xFFFFAF00, 0xFFFFB000, 0xFFFFB100, 0xFFFFB200, 0xFFFFB300, 0xFFFFB400, 0xFFFFB500, 0xFFFFB600, 0xFFFFB700, 0xFFFFB800, 0xFFFFB900, 0xFFFFBA00, 0xFFFFBB00, 0xFFFFBC00, 0xFFFFBD00, 0xFFFFBE00, 0xFFFFBF00, 0xFFFFC000, 0xFFFFC100, 0xFFFFC200, 0xFFFFC300, 0xFFFFC400, 0xFFFFC500, 0xFFFFC600, 0xFFFFC700, 0xFFFFC800, 0xFFFFC900, 0xFFFFCA00, 0xFFFFCB00, 0xFFFFCC00, 0xFFFFCD00, 0xFFFFCE00, 0xFFFFCF00, 0xFFFFD000, 0xFFFFD100, 0xFFFFD200, 0xFFFFD300, 0xFFFFD400, 0xFFFFD500, 0xFFFFD600, 0xFFFFD700, 0xFFFFD800, 0xFFFFD900, 0xFFFFDA00, 0xFFFFDB00, 0xFFFFDC00, 0xFFFFDD00, 0xFFFFDE00, 0xFFFFDF00, 0xFFFFE000, 0xFFFFE100, 0xFFFFE200, 0xFFFFE300, 0xFFFFE400, 0xFFFFE500, 0xFFFFE600, 0xFFFFE700, 0xFFFFE800, 0xFFFFE900, 0xFFFFEA00, 0xFFFFEB00, 0xFFFFEC00, 0xFFFFED00, 0xFFFFEE00, 0xFFFFEF00, 0xFFFFF000, 0xFFFFF100, 0xFFFFF200, 0xFFFFF300, 0xFFFFF400, 0xFFFFF500, 0xFFFFF600, 0xFFFFF700, 0xFFFFF800, 0xFFFFF900, 0xFFFFFA00, 0xFFFFFB00, 0xFFFFFC00, 0xFFFFFD00, 0xFFFFFE00, 0xFFFFFF00, 0xFFFEFF00, 0xFFFDFF00, 0xFFFCFF00, 0xFFFBFF00, 0xFFFAFF00, 0xFFF9FF00, 0xFFF8FF00, 0xFFF7FF00, 0xFFF6FF00, 0xFFF5FF00, 0xFFF4FF00, 0xFFF3FF00, 0xFFF2FF00, 0xFFF1FF00, 0xFFF0FF00, 0xFFEFFF00, 0xFFEEFF00, 0xFFEDFF00, 0xFFECFF00, 0xFFEBFF00, 0xFFEAFF00, 0xFFE9FF00, 0xFFE8FF00, 0xFFE7FF00, 0xFFE6FF00, 0xFFE5FF00, 0xFFE4FF00, 0xFFE3FF00, 0xFFE2FF00, 0xFFE1FF00, 0xFFE0FF00, 0xFFDFFF00, 0xFFDEFF00, 0xFFDDFF00, 0xFFDCFF00, 0xFFDBFF00, 0xFFDAFF00, 0xFFD9FF00, 0xFFD8FF00, 0xFFD7FF00, 0xFFD6FF00, 0xFFD5FF00, 0xFFD4FF00, 0xFFD3FF00, 0xFFD2FF00, 0xFFD1FF00, 0xFFD0FF00, 0xFFCFFF00, 0xFFCEFF00, 0xFFCDFF00, 0xFFCCFF00, 0xFFCBFF00, 0xFFCAFF00, 0xFFC9FF00, 0xFFC8FF00, 0xFFC7FF00, 0xFFC6FF00, 0xFFC5FF00, 0xFFC4FF00, 0xFFC3FF00, 0xFFC2FF00, 0xFFC1FF00, 0xFFC0FF00, 0xFFBFFF00, 0xFFBEFF00, 0xFFBDFF00, 0xFFBCFF00, 0xFFBBFF00, 0xFFBAFF00, 0xFFB9FF00, 0xFFB8FF00, 0xFFB7FF00, 0xFFB6FF00, 0xFFB5FF00, 0xFFB4FF00, 0xFFB3FF00, 0xFFB2FF00, 0xFFB1FF00, 0xFFB0FF00, 0xFFAFFF00, 0xFFAEFF00, 0xFFADFF00, 0xFFACFF00, 0xFFABFF00, 0xFFAAFF00, 0xFFA9FF00, 0xFFA8FF00, 0xFFA7FF00, 0xFFA6FF00, 0xFFA5FF00, 0xFFA4FF00, 0xFFA3FF00, 0xFFA2FF00, 0xFFA1FF00, 0xFFA0FF00, 0xFF9FFF00, 0xFF9EFF00, 0xFF9DFF00, 0xFF9CFF00, 0xFF9BFF00, 0xFF9AFF00, 0xFF99FF00, 0xFF98FF00, 0xFF97FF00, 0xFF96FF00, 0xFF95FF00, 0xFF94FF00, 0xFF93FF00, 0xFF92FF00, 0xFF91FF00, 0xFF90FF00, 0xFF8FFF00, 0xFF8EFF00, 0xFF8DFF00, 0xFF8CFF00, 0xFF8BFF00, 0xFF8AFF00, 0xFF89FF00, 0xFF88FF00, 0xFF87FF00, 0xFF86FF00, 0xFF85FF00, 0xFF84FF00, 0xFF83FF00, 0xFF82FF00, 0xFF81FF00, 0xFF80FF00, 0xFF7FFF00, 0xFF7EFF00, 0xFF7DFF00, 0xFF7CFF00, 0xFF7BFF00, 0xFF7AFF00, 0xFF79FF00, 0xFF78FF00, 0xFF77FF00, 0xFF76FF00, 0xFF75FF00, 0xFF74FF00, 0xFF73FF00, 0xFF72FF00, 0xFF71FF00, 0xFF70FF00, 0xFF6FFF00, 0xFF6EFF00, 0xFF6DFF00, 0xFF6CFF00, 0xFF6BFF00, 0xFF6AFF00, 0xFF69FF00, 0xFF68FF00, 0xFF67FF00, 0xFF66FF00, 0xFF65FF00, 0xFF64FF00, 0xFF63FF00, 0xFF62FF00, 0xFF61FF00, 0xFF60FF00, 0xFF5FFF00, 0xFF5EFF00, 0xFF5DFF00, 0xFF5CFF00, 0xFF5BFF00, 0xFF5AFF00, 0xFF59FF00, 0xFF58FF00, 0xFF57FF00, 0xFF56FF00, 0xFF55FF00, 0xFF54FF00, 0xFF53FF00, 0xFF52FF00, 0xFF51FF00, 0xFF50FF00, 0xFF4FFF00, 0xFF4EFF00, 0xFF4DFF00, 0xFF4CFF00, 0xFF4BFF00, 0xFF4AFF00, 0xFF49FF00, 0xFF48FF00, 0xFF47FF00, 0xFF46FF00, 0xFF45FF00, 0xFF44FF00, 0xFF43FF00, 0xFF42FF00, 0xFF41FF00, 0xFF40FF00, 0xFF3FFF00, 0xFF3EFF00, 0xFF3DFF00, 0xFF3CFF00, 0xFF3BFF00, 0xFF3AFF00, 0xFF39FF00, 0xFF38FF00, 0xFF37FF00, 0xFF36FF00, 0xFF35FF00, 0xFF34FF00, 0xFF33FF00, 0xFF32FF00, 0xFF31FF00, 0xFF30FF00, 0xFF2FFF00, 0xFF2EFF00, 0xFF2DFF00, 0xFF2CFF00, 0xFF2BFF00, 0xFF2AFF00, 0xFF29FF00, 0xFF28FF00, 0xFF27FF00, 0xFF26FF00, 0xFF25FF00, 0xFF24FF00, 0xFF23FF00, 0xFF22FF00, 0xFF21FF00, 0xFF20FF00, 0xFF1FFF00, 0xFF1EFF00, 0xFF1DFF00, 0xFF1CFF00, 0xFF1BFF00, 0xFF1AFF00, 0xFF19FF00, 0xFF18FF00, 0xFF17FF00, 0xFF16FF00, 0xFF15FF00, 0xFF14FF00, 0xFF13FF00, 0xFF12FF00, 0xFF11FF00, 0xFF10FF00, 0xFF0FFF00, 0xFF0EFF00, 0xFF0DFF00, 0xFF0CFF00, 0xFF0BFF00, 0xFF0AFF00, 0xFF09FF00, 0xFF08FF00, 0xFF07FF00, 0xFF06FF00, 0xFF05FF00, 0xFF04FF00, 0xFF03FF00, 0xFF02FF00, 0xFF01FF00, 0xFF00FF00, 0xFF00FF01, 0xFF00FF02, 0xFF00FF03, 0xFF00FF04, 0xFF00FF05, 0xFF00FF06, 0xFF00FF07, 0xFF00FF08, 0xFF00FF09, 0xFF00FF0A, 0xFF00FF0B, 0xFF00FF0C, 0xFF00FF0D, 0xFF00FF0E, 0xFF00FF0F, 0xFF00FF10, 0xFF00FF11, 0xFF00FF12, 0xFF00FF13, 0xFF00FF14, 0xFF00FF15, 0xFF00FF16, 0xFF00FF17, 0xFF00FF18, 0xFF00FF19, 0xFF00FF1A, 0xFF00FF1B, 0xFF00FF1C, 0xFF00FF1D, 0xFF00FF1E, 0xFF00FF1F, 0xFF00FF20, 0xFF00FF21, 0xFF00FF22, 0xFF00FF23, 0xFF00FF24, 0xFF00FF25, 0xFF00FF26, 0xFF00FF27, 0xFF00FF28, 0xFF00FF29, 0xFF00FF2A, 0xFF00FF2B, 0xFF00FF2C, 0xFF00FF2D, 0xFF00FF2E, 0xFF00FF2F, 0xFF00FF30, 0xFF00FF31, 0xFF00FF32, 0xFF00FF33, 0xFF00FF34, 0xFF00FF35, 0xFF00FF36, 0xFF00FF37, 0xFF00FF38, 0xFF00FF39, 0xFF00FF3A, 0xFF00FF3B, 0xFF00FF3C, 0xFF00FF3D, 0xFF00FF3E, 0xFF00FF3F, 0xFF00FF40, 0xFF00FF41, 0xFF00FF42, 0xFF00FF43, 0xFF00FF44, 0xFF00FF45, 0xFF00FF46, 0xFF00FF47, 0xFF00FF48, 0xFF00FF49, 0xFF00FF4A, 0xFF00FF4B, 0xFF00FF4C, 0xFF00FF4D, 0xFF00FF4E, 0xFF00FF4F, 0xFF00FF50, 0xFF00FF51, 0xFF00FF52, 0xFF00FF53, 0xFF00FF54, 0xFF00FF55, 0xFF00FF56, 0xFF00FF57, 0xFF00FF58, 0xFF00FF59, 0xFF00FF5A, 0xFF00FF5B, 0xFF00FF5C, 0xFF00FF5D, 0xFF00FF5E, 0xFF00FF5F, 0xFF00FF60, 0xFF00FF61, 0xFF00FF62, 0xFF00FF63, 0xFF00FF64, 0xFF00FF65, 0xFF00FF66, 0xFF00FF67, 0xFF00FF68, 0xFF00FF69, 0xFF00FF6A, 0xFF00FF6B, 0xFF00FF6C, 0xFF00FF6D, 0xFF00FF6E, 0xFF00FF6F, 0xFF00FF70, 0xFF00FF71, 0xFF00FF72, 0xFF00FF73, 0xFF00FF74, 0xFF00FF75, 0xFF00FF76, 0xFF00FF77, 0xFF00FF78, 0xFF00FF79, 0xFF00FF7A, 0xFF00FF7B, 0xFF00FF7C, 0xFF00FF7D, 0xFF00FF7E, 0xFF00FF7F, 0xFF00FF80, 0xFF00FF81, 0xFF00FF82, 0xFF00FF83, 0xFF00FF84, 0xFF00FF85, 0xFF00FF86, 0xFF00FF87, 0xFF00FF88, 0xFF00FF89, 0xFF00FF8A, 0xFF00FF8B, 0xFF00FF8C, 0xFF00FF8D, 0xFF00FF8E, 0xFF00FF8F, 0xFF00FF90, 0xFF00FF91, 0xFF00FF92, 0xFF00FF93, 0xFF00FF94, 0xFF00FF95, 0xFF00FF96, 0xFF00FF97, 0xFF00FF98, 0xFF00FF99, 0xFF00FF9A, 0xFF00FF9B, 0xFF00FF9C, 0xFF00FF9D, 0xFF00FF9E, 0xFF00FF9F, 0xFF00FFA0, 0xFF00FFA1, 0xFF00FFA2, 0xFF00FFA3, 0xFF00FFA4, 0xFF00FFA5, 0xFF00FFA6, 0xFF00FFA7, 0xFF00FFA8, 0xFF00FFA9, 0xFF00FFAA, 0xFF00FFAB, 0xFF00FFAC, 0xFF00FFAD, 0xFF00FFAE, 0xFF00FFAF, 0xFF00FFB0, 0xFF00FFB1, 0xFF00FFB2, 0xFF00FFB3, 0xFF00FFB4, 0xFF00FFB5, 0xFF00FFB6, 0xFF00FFB7, 0xFF00FFB8, 0xFF00FFB9, 0xFF00FFBA, 0xFF00FFBB, 0xFF00FFBC, 0xFF00FFBD, 0xFF00FFBE, 0xFF00FFBF, 0xFF00FFC0, 0xFF00FFC1, 0xFF00FFC2, 0xFF00FFC3, 0xFF00FFC4, 0xFF00FFC5, 0xFF00FFC6, 0xFF00FFC7, 0xFF00FFC8, 0xFF00FFC9, 0xFF00FFCA, 0xFF00FFCB, 0xFF00FFCC, 0xFF00FFCD, 0xFF00FFCE, 0xFF00FFCF, 0xFF00FFD0, 0xFF00FFD1, 0xFF00FFD2, 0xFF00FFD3, 0xFF00FFD4, 0xFF00FFD5, 0xFF00FFD6, 0xFF00FFD7, 0xFF00FFD8, 0xFF00FFD9, 0xFF00FFDA, 0xFF00FFDB, 0xFF00FFDC, 0xFF00FFDD, 0xFF00FFDE, 0xFF00FFDF, 0xFF00FFE0, 0xFF00FFE1, 0xFF00FFE2, 0xFF00FFE3, 0xFF00FFE4, 0xFF00FFE5, 0xFF00FFE6, 0xFF00FFE7, 0xFF00FFE8, 0xFF00FFE9, 0xFF00FFEA, 0xFF00FFEB, 0xFF00FFEC, 0xFF00FFED, 0xFF00FFEE, 0xFF00FFEF, 0xFF00FFF0, 0xFF00FFF1, 0xFF00FFF2, 0xFF00FFF3, 0xFF00FFF4, 0xFF00FFF5, 0xFF00FFF6, 0xFF00FFF7, 0xFF00FFF8, 0xFF00FFF9, 0xFF00FFFA, 0xFF00FFFB, 0xFF00FFFC, 0xFF00FFFD, 0xFF00FFFE, 0xFF00FFFF, 0xFF00FEFF, 0xFF00FDFF, 0xFF00FCFF, 0xFF00FBFF, 0xFF00FAFF, 0xFF00F9FF, 0xFF00F8FF, 0xFF00F7FF, 0xFF00F6FF, 0xFF00F5FF, 0xFF00F4FF, 0xFF00F3FF, 0xFF00F2FF, 0xFF00F1FF, 0xFF00F0FF, 0xFF00EFFF, 0xFF00EEFF, 0xFF00EDFF, 0xFF00ECFF, 0xFF00EBFF, 0xFF00EAFF, 0xFF00E9FF, 0xFF00E8FF, 0xFF00E7FF, 0xFF00E6FF, 0xFF00E5FF, 0xFF00E4FF, 0xFF00E3FF, 0xFF00E2FF, 0xFF00E1FF, 0xFF00E0FF, 0xFF00DFFF, 0xFF00DEFF, 0xFF00DDFF, 0xFF00DCFF, 0xFF00DBFF, 0xFF00DAFF, 0xFF00D9FF, 0xFF00D8FF, 0xFF00D7FF, 0xFF00D6FF, 0xFF00D5FF, 0xFF00D4FF, 0xFF00D3FF, 0xFF00D2FF, 0xFF00D1FF, 0xFF00D0FF, 0xFF00CFFF, 0xFF00CEFF, 0xFF00CDFF, 0xFF00CCFF, 0xFF00CBFF, 0xFF00CAFF, 0xFF00C9FF, 0xFF00C8FF, 0xFF00C7FF, 0xFF00C6FF, 0xFF00C5FF, 0xFF00C4FF, 0xFF00C3FF, 0xFF00C2FF, 0xFF00C1FF, 0xFF00C0FF, 0xFF00BFFF, 0xFF00BEFF, 0xFF00BDFF, 0xFF00BCFF, 0xFF00BBFF, 0xFF00BAFF, 0xFF00B9FF, 0xFF00B8FF, 0xFF00B7FF, 0xFF00B6FF, 0xFF00B5FF, 0xFF00B4FF, 0xFF00B3FF, 0xFF00B2FF, 0xFF00B1FF, 0xFF00B0FF, 0xFF00AFFF, 0xFF00AEFF, 0xFF00ADFF, 0xFF00ACFF, 0xFF00ABFF, 0xFF00AAFF, 0xFF00A9FF, 0xFF00A8FF, 0xFF00A7FF, 0xFF00A6FF, 0xFF00A5FF, 0xFF00A4FF, 0xFF00A3FF, 0xFF00A2FF, 0xFF00A1FF, 0xFF00A0FF, 0xFF009FFF, 0xFF009EFF, 0xFF009DFF, 0xFF009CFF, 0xFF009BFF, 0xFF009AFF, 0xFF0099FF, 0xFF0098FF, 0xFF0097FF, 0xFF0096FF, 0xFF0095FF, 0xFF0094FF, 0xFF0093FF, 0xFF0092FF, 0xFF0091FF, 0xFF0090FF, 0xFF008FFF, 0xFF008EFF, 0xFF008DFF, 0xFF008CFF, 0xFF008BFF, 0xFF008AFF, 0xFF0089FF, 0xFF0088FF, 0xFF0087FF, 0xFF0086FF, 0xFF0085FF, 0xFF0084FF, 0xFF0083FF, 0xFF0082FF, 0xFF0081FF, 0xFF0080FF, 0xFF007FFF, 0xFF007EFF, 0xFF007DFF, 0xFF007CFF, 0xFF007BFF, 0xFF007AFF, 0xFF0079FF, 0xFF0078FF, 0xFF0077FF, 0xFF0076FF, 0xFF0075FF, 0xFF0074FF, 0xFF0073FF, 0xFF0072FF, 0xFF0071FF, 0xFF0070FF, 0xFF006FFF, 0xFF006EFF, 0xFF006DFF, 0xFF006CFF, 0xFF006BFF, 0xFF006AFF, 0xFF0069FF, 0xFF0068FF, 0xFF0067FF, 0xFF0066FF, 0xFF0065FF, 0xFF0064FF, 0xFF0063FF, 0xFF0062FF, 0xFF0061FF, 0xFF0060FF, 0xFF005FFF, 0xFF005EFF, 0xFF005DFF, 0xFF005CFF, 0xFF005BFF, 0xFF005AFF, 0xFF0059FF, 0xFF0058FF, 0xFF0057FF, 0xFF0056FF, 0xFF0055FF, 0xFF0054FF, 0xFF0053FF, 0xFF0052FF, 0xFF0051FF, 0xFF0050FF, 0xFF004FFF, 0xFF004EFF, 0xFF004DFF, 0xFF004CFF, 0xFF004BFF, 0xFF004AFF, 0xFF0049FF, 0xFF0048FF, 0xFF0047FF, 0xFF0046FF, 0xFF0045FF, 0xFF0044FF, 0xFF0043FF, 0xFF0042FF, 0xFF0041FF, 0xFF0040FF, 0xFF003FFF, 0xFF003EFF, 0xFF003DFF, 0xFF003CFF, 0xFF003BFF, 0xFF003AFF, 0xFF0039FF, 0xFF0038FF, 0xFF0037FF, 0xFF0036FF, 0xFF0035FF, 0xFF0034FF, 0xFF0033FF, 0xFF0032FF, 0xFF0031FF, 0xFF0030FF, 0xFF002FFF, 0xFF002EFF, 0xFF002DFF, 0xFF002CFF, 0xFF002BFF, 0xFF002AFF, 0xFF0029FF, 0xFF0028FF, 0xFF0027FF, 0xFF0026FF, 0xFF0025FF, 0xFF0024FF, 0xFF0023FF, 0xFF0022FF, 0xFF0021FF, 0xFF0020FF, 0xFF001FFF, 0xFF001EFF, 0xFF001DFF, 0xFF001CFF, 0xFF001BFF, 0xFF001AFF, 0xFF0019FF, 0xFF0018FF, 0xFF0017FF, 0xFF0016FF, 0xFF0015FF, 0xFF0014FF, 0xFF0013FF, 0xFF0012FF, 0xFF0011FF, 0xFF0010FF, 0xFF000FFF, 0xFF000EFF, 0xFF000DFF, 0xFF000CFF, 0xFF000BFF, 0xFF000AFF, 0xFF0009FF, 0xFF0008FF, 0xFF0007FF, 0xFF0006FF, 0xFF0005FF, 0xFF0004FF, 0xFF0003FF, 0xFF0002FF, 0xFF0001FF, 0xFF0000FF, 0xFF0100FF, 0xFF0200FF, 0xFF0300FF, 0xFF0400FF, 0xFF0500FF, 0xFF0600FF, 0xFF0700FF, 0xFF0800FF, 0xFF0900FF, 0xFF0A00FF, 0xFF0B00FF, 0xFF0C00FF, 0xFF0D00FF, 0xFF0E00FF, 0xFF0F00FF, 0xFF1000FF, 0xFF1100FF, 0xFF1200FF, 0xFF1300FF, 0xFF1400FF, 0xFF1500FF, 0xFF1600FF, 0xFF1700FF, 0xFF1800FF, 0xFF1900FF, 0xFF1A00FF, 0xFF1B00FF, 0xFF1C00FF, 0xFF1D00FF, 0xFF1E00FF, 0xFF1F00FF, 0xFF2000FF, 0xFF2100FF, 0xFF2200FF, 0xFF2300FF, 0xFF2400FF, 0xFF2500FF, 0xFF2600FF, 0xFF2700FF, 0xFF2800FF, 0xFF2900FF, 0xFF2A00FF, 0xFF2B00FF, 0xFF2C00FF, 0xFF2D00FF, 0xFF2E00FF, 0xFF2F00FF, 0xFF3000FF, 0xFF3100FF, 0xFF3200FF, 0xFF3300FF, 0xFF3400FF, 0xFF3500FF, 0xFF3600FF, 0xFF3700FF, 0xFF3800FF, 0xFF3900FF, 0xFF3A00FF, 0xFF3B00FF, 0xFF3C00FF, 0xFF3D00FF, 0xFF3E00FF, 0xFF3F00FF, 0xFF4000FF, 0xFF4100FF, 0xFF4200FF, 0xFF4300FF, 0xFF4400FF, 0xFF4500FF, 0xFF4600FF, 0xFF4700FF, 0xFF4800FF, 0xFF4900FF, 0xFF4A00FF, 0xFF4B00FF, 0xFF4C00FF, 0xFF4D00FF, 0xFF4E00FF, 0xFF4F00FF, 0xFF5000FF, 0xFF5100FF, 0xFF5200FF, 0xFF5300FF, 0xFF5400FF, 0xFF5500FF, 0xFF5600FF, 0xFF5700FF, 0xFF5800FF, 0xFF5900FF, 0xFF5A00FF, 0xFF5B00FF, 0xFF5C00FF, 0xFF5D00FF, 0xFF5E00FF, 0xFF5F00FF, 0xFF6000FF, 0xFF6100FF, 0xFF6200FF, 0xFF6300FF, 0xFF6400FF, 0xFF6500FF, 0xFF6600FF, 0xFF6700FF, 0xFF6800FF, 0xFF6900FF, 0xFF6A00FF, 0xFF6B00FF, 0xFF6C00FF, 0xFF6D00FF, 0xFF6E00FF, 0xFF6F00FF, 0xFF7000FF, 0xFF7100FF, 0xFF7200FF, 0xFF7300FF, 0xFF7400FF, 0xFF7500FF, 0xFF7600FF, 0xFF7700FF, 0xFF7800FF, 0xFF7900FF, 0xFF7A00FF, 0xFF7B00FF, 0xFF7C00FF, 0xFF7D00FF, 0xFF7E00FF, 0xFF7F00FF, 0xFF8000FF, 0xFF8100FF, 0xFF8200FF, 0xFF8300FF, 0xFF8400FF, 0xFF8500FF, 0xFF8600FF, 0xFF8700FF, 0xFF8800FF, 0xFF8900FF, 0xFF8A00FF, 0xFF8B00FF, 0xFF8C00FF, 0xFF8D00FF, 0xFF8E00FF, 0xFF8F00FF, 0xFF9000FF, 0xFF9100FF, 0xFF9200FF, 0xFF9300FF, 0xFF9400FF, 0xFF9500FF, 0xFF9600FF, 0xFF9700FF, 0xFF9800FF, 0xFF9900FF, 0xFF9A00FF, 0xFF9B00FF, 0xFF9C00FF, 0xFF9D00FF, 0xFF9E00FF, 0xFF9F00FF, 0xFFA000FF, 0xFFA100FF, 0xFFA200FF, 0xFFA300FF, 0xFFA400FF, 0xFFA500FF, 0xFFA600FF, 0xFFA700FF, 0xFFA800FF, 0xFFA900FF, 0xFFAA00FF, 0xFFAB00FF, 0xFFAC00FF, 0xFFAD00FF, 0xFFAE00FF, 0xFFAF00FF, 0xFFB000FF, 0xFFB100FF, 0xFFB200FF, 0xFFB300FF, 0xFFB400FF, 0xFFB500FF, 0xFFB600FF, 0xFFB700FF, 0xFFB800FF, 0xFFB900FF, 0xFFBA00FF, 0xFFBB00FF, 0xFFBC00FF, 0xFFBD00FF, 0xFFBE00FF, 0xFFBF00FF, 0xFFC000FF, 0xFFC100FF, 0xFFC200FF, 0xFFC300FF, 0xFFC400FF, 0xFFC500FF, 0xFFC600FF, 0xFFC700FF, 0xFFC800FF, 0xFFC900FF, 0xFFCA00FF, 0xFFCB00FF, 0xFFCC00FF, 0xFFCD00FF, 0xFFCE00FF, 0xFFCF00FF, 0xFFD000FF, 0xFFD100FF, 0xFFD200FF, 0xFFD300FF, 0xFFD400FF, 0xFFD500FF, 0xFFD600FF, 0xFFD700FF, 0xFFD800FF, 0xFFD900FF, 0xFFDA00FF, 0xFFDB00FF, 0xFFDC00FF, 0xFFDD00FF, 0xFFDE00FF, 0xFFDF00FF, 0xFFE000FF, 0xFFE100FF, 0xFFE200FF, 0xFFE300FF, 0xFFE400FF, 0xFFE500FF, 0xFFE600FF, 0xFFE700FF, 0xFFE800FF, 0xFFE900FF, 0xFFEA00FF, 0xFFEB00FF, 0xFFEC00FF, 0xFFED00FF, 0xFFEE00FF, 0xFFEF00FF, 0xFFF000FF, 0xFFF100FF, 0xFFF200FF, 0xFFF300FF, 0xFFF400FF, 0xFFF500FF, 0xFFF600FF, 0xFFF700FF, 0xFFF800FF, 0xFFF900FF, 0xFFFA00FF, 0xFFFB00FF, 0xFFFC00FF, 0xFFFD00FF, 0xFFFE00FF, 0xFFFF00FF, 0xFFFF00FE, 0xFFFF00FD, 0xFFFF00FC, 0xFFFF00FB, 0xFFFF00FA, 0xFFFF00F9, 0xFFFF00F8, 0xFFFF00F7, 0xFFFF00F6, 0xFFFF00F5, 0xFFFF00F4, 0xFFFF00F3, 0xFFFF00F2, 0xFFFF00F1, 0xFFFF00F0, 0xFFFF00EF, 0xFFFF00EE, 0xFFFF00ED, 0xFFFF00EC, 0xFFFF00EB, 0xFFFF00EA, 0xFFFF00E9, 0xFFFF00E8, 0xFFFF00E7, 0xFFFF00E6, 0xFFFF00E5, 0xFFFF00E4, 0xFFFF00E3, 0xFFFF00E2, 0xFFFF00E1, 0xFFFF00E0, 0xFFFF00DF, 0xFFFF00DE, 0xFFFF00DD, 0xFFFF00DC, 0xFFFF00DB, 0xFFFF00DA, 0xFFFF00D9, 0xFFFF00D8, 0xFFFF00D7, 0xFFFF00D6, 0xFFFF00D5, 0xFFFF00D4, 0xFFFF00D3, 0xFFFF00D2, 0xFFFF00D1, 0xFFFF00D0, 0xFFFF00CF, 0xFFFF00CE, 0xFFFF00CD, 0xFFFF00CC, 0xFFFF00CB, 0xFFFF00CA, 0xFFFF00C9, 0xFFFF00C8, 0xFFFF00C7, 0xFFFF00C6, 0xFFFF00C5, 0xFFFF00C4, 0xFFFF00C3, 0xFFFF00C2, 0xFFFF00C1, 0xFFFF00C0, 0xFFFF00BF, 0xFFFF00BE, 0xFFFF00BD, 0xFFFF00BC, 0xFFFF00BB, 0xFFFF00BA, 0xFFFF00B9, 0xFFFF00B8, 0xFFFF00B7, 0xFFFF00B6, 0xFFFF00B5, 0xFFFF00B4, 0xFFFF00B3, 0xFFFF00B2, 0xFFFF00B1, 0xFFFF00B0, 0xFFFF00AF, 0xFFFF00AE, 0xFFFF00AD, 0xFFFF00AC, 0xFFFF00AB, 0xFFFF00AA, 0xFFFF00A9, 0xFFFF00A8, 0xFFFF00A7, 0xFFFF00A6, 0xFFFF00A5, 0xFFFF00A4, 0xFFFF00A3, 0xFFFF00A2, 0xFFFF00A1, 0xFFFF00A0, 0xFFFF009F, 0xFFFF009E, 0xFFFF009D, 0xFFFF009C, 0xFFFF009B, 0xFFFF009A, 0xFFFF0099, 0xFFFF0098, 0xFFFF0097, 0xFFFF0096, 0xFFFF0095, 0xFFFF0094, 0xFFFF0093, 0xFFFF0092, 0xFFFF0091, 0xFFFF0090, 0xFFFF008F, 0xFFFF008E, 0xFFFF008D, 0xFFFF008C, 0xFFFF008B, 0xFFFF008A, 0xFFFF0089, 0xFFFF0088, 0xFFFF0087, 0xFFFF0086, 0xFFFF0085, 0xFFFF0084, 0xFFFF0083, 0xFFFF0082, 0xFFFF0081, 0xFFFF0080, 0xFFFF007F, 0xFFFF007E, 0xFFFF007D, 0xFFFF007C, 0xFFFF007B, 0xFFFF007A, 0xFFFF0079, 0xFFFF0078, 0xFFFF0077, 0xFFFF0076, 0xFFFF0075, 0xFFFF0074, 0xFFFF0073, 0xFFFF0072, 0xFFFF0071, 0xFFFF0070, 0xFFFF006F, 0xFFFF006E, 0xFFFF006D, 0xFFFF006C, 0xFFFF006B, 0xFFFF006A, 0xFFFF0069, 0xFFFF0068, 0xFFFF0067, 0xFFFF0066, 0xFFFF0065, 0xFFFF0064, 0xFFFF0063, 0xFFFF0062, 0xFFFF0061, 0xFFFF0060, 0xFFFF005F, 0xFFFF005E, 0xFFFF005D, 0xFFFF005C, 0xFFFF005B, 0xFFFF005A, 0xFFFF0059, 0xFFFF0058, 0xFFFF0057, 0xFFFF0056, 0xFFFF0055, 0xFFFF0054, 0xFFFF0053, 0xFFFF0052, 0xFFFF0051, 0xFFFF0050, 0xFFFF004F, 0xFFFF004E, 0xFFFF004D, 0xFFFF004C, 0xFFFF004B, 0xFFFF004A, 0xFFFF0049, 0xFFFF0048, 0xFFFF0047, 0xFFFF0046, 0xFFFF0045, 0xFFFF0044, 0xFFFF0043, 0xFFFF0042, 0xFFFF0041, 0xFFFF0040, 0xFFFF003F, 0xFFFF003E, 0xFFFF003D, 0xFFFF003C, 0xFFFF003B, 0xFFFF003A, 0xFFFF0039, 0xFFFF0038, 0xFFFF0037, 0xFFFF0036, 0xFFFF0035, 0xFFFF0034, 0xFFFF0033, 0xFFFF0032, 0xFFFF0031, 0xFFFF0030, 0xFFFF002F, 0xFFFF002E, 0xFFFF002D, 0xFFFF002C, 0xFFFF002B, 0xFFFF002A, 0xFFFF0029, 0xFFFF0028, 0xFFFF0027, 0xFFFF0026, 0xFFFF0025, 0xFFFF0024, 0xFFFF0023, 0xFFFF0022, 0xFFFF0021, 0xFFFF0020, 0xFFFF001F, 0xFFFF001E, 0xFFFF001D, 0xFFFF001C, 0xFFFF001B, 0xFFFF001A, 0xFFFF0019, 0xFFFF0018, 0xFFFF0017, 0xFFFF0016, 0xFFFF0015, 0xFFFF0014, 0xFFFF0013, 0xFFFF0012, 0xFFFF0011, 0xFFFF0010, 0xFFFF000F, 0xFFFF000E, 0xFFFF000D, 0xFFFF000C, 0xFFFF000B, 0xFFFF000A, 0xFFFF0009, 0xFFFF0008, 0xFFFF0007, 0xFFFF0006, 0xFFFF0005, 0xFFFF0004, 0xFFFF0003, 0xFFFF0002, 0xFFFF0001 };
const int ghostPixels = 2;
bool alterDiffuseColor(uint32 dwV0, uint32 dwV1, uint32 dwV2, uint32 dwV3, uint32 dwV4, uint32 dwV5, 
					   uint32 dc0, uint32 dc1, uint32 dc2, uint32 dc3, uint32 dc4, uint32 dc5,
					   uint32 dcr0, uint32 dcr1, uint32 dcr2, uint32 dcr3, uint32 dcr4, uint32 dcr5) {
	

	if (g_dwVtxDifColor[dwV0] == dc0 && g_dwVtxDifColor[dwV1] == dc1 && g_dwVtxDifColor[dwV2] == dc2 &&
		g_dwVtxDifColor[dwV3] == dc3 && g_dwVtxDifColor[dwV4] == dc4 && g_dwVtxDifColor[dwV5] == dc5) {

		g_dwVtxDifColor[dwV0] = dcr0;
		g_dwVtxDifColor[dwV1] = dcr1;
		g_dwVtxDifColor[dwV2] = dcr2;
		g_dwVtxDifColor[dwV3] = dcr3;
		g_dwVtxDifColor[dwV4] = dcr4;
		g_dwVtxDifColor[dwV5] = dcr5;

		return true;
	}

	return false;
}

bool firstTri = false;
bool isFirstTri(uint32 dwV0, uint32 dwV1) {
	int y0 = (int) (g_vecProjected[dwV0].y*gRSP.vtxYMul+gRSP.vtxYAdd);
	int y1 = (int) (g_vecProjected[dwV1].y*gRSP.vtxYMul+gRSP.vtxYAdd);
	bool firstTri = ((y0 - y1) < (windowSetting.uDisplayHeight / 4)) || (y1 > -ghostPixels && y1 < ghostPixels);
	DebuggerAppendMsg("fst tri : %d", firstTri);
	//firstTri = !firstTri;
	return firstTri;
}

void overrideBackground(uint32 dwV0, uint32 dwV1, uint32 dwV2, uint32 dwV3, uint32 dwV4, uint32 dwV5) {
	//  BAS DROITE, HAUT GAUCHE, BAS GAUCHE, HAUT DROIT, HAUT GAUCHE, BAS DROITE
	//	DebuggerAppendMsg("painting bg, ctrack is : %d", currentTrack);

	switch (currentTrack) {
			
		// luigi raceway
		case 1 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFFD8E8F8, 0xFF80B8F8, 0xFFD8E8F8, 0xFF80B8F8, 0xFF80B8F8, 0xFFD8E8F8,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFFD8E8F8, 0xFF000000, 0xFFD8E8F8, 0xFFD8E8F8, 0xFF000000,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
				);
			break;
		}

		// moo moo farm
		case 2 : {
			alterDiffuseColor(
				dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
				0xFFC5D3FF, 0xFF0012FF, 0xFFC5D3FF, 0xFF0012FF, 0xFF0012FF, 0xFFC5D3FF,
				0xFFA4C2F5, 0xFFDEA3F4, 0xFFA4C2F5, 0xFFDEA3F4, 0xFFDEA3F4, 0xFFA4C2F5
			);
			break;
		}

		// koopa troopa beach 
		case 3 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFFD8E8F8, 0xFF309878, 0xFFD8E8F8, 0xFF309878, 0xFF309878, 0xFFD8E8F8,
					0xFF212AAE, 0xFF212AAE, 0xFF212AAE, 0xFF212AAE, 0xFF212AAE, 0xFF212AAE
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF309878, 0xFF000000, 0xFF309878, 0xFF309878, 0xFF000000,
					0xFF2A6FFD, 0xFF2A6FFD, 0xFF2A6FFD, 0xFF2A6FFD, 0xFF2A6FFD, 0xFF2A6FFD
				);
			break;
		}

		// kalimari desert 
		case 4 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFFFFC000, 0xFFC3E7FF, 0xFFFFC000, 0xFFC3E7FF, 0xFFC3E7FF, 0xFFFFC000,
					0xFF2D5DA0, 0xFF003550, 0xFF2D5DA0, 0xFF003550, 0xFF003550, 0xFF2D5DA0
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFFFFC000, 0xFF000000, 0xFFFFC000, 0xFFFFC000, 0xFF000000,
					0xFF2D5DA0, 0xFF2D5DA0, 0xFF2D5DA0, 0xFF2D5DA0, 0xFF2D5DA0, 0xFF2D5DA0
				);
			break;
		}

		// toad's turnpike
		case 5 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFFD14117, 0xFF00025E, 0xFFD14117, 0xFF00025E, 0xFF00025E, 0xFFD14117,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFFD14117, 0xFF000000, 0xFFD14117, 0xFFD14117, 0xFF000000,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
				);
			break;
		}

		// frappe snowland 
		case 6 : {
			alterDiffuseColor(
				dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
				0xFF0063A4, 0xFF1C0B5A, 0xFF0063A4, 0xFF1C0B5A, 0xFF1C0B5A, 0xFF0063A4,
				0xFFFF1A00, 0xFF300600, 0xFFFF1A00, 0xFF300600, 0xFF300600, 0xFFFF1A00
			);
			break;
		}

		// choco mountain 
		case 7 : {
			alterDiffuseColor(
				dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
				0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
				0xFFFFFFFF, 0xFF005AE1, 0xFFFFFFFF, 0xFF005AE1, 0xFF005AE1, 0xFFFFFFFF
			);
			break;
		}

		// mario raceway 
		case 8 : {
			alterDiffuseColor(
				dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
				0xFFD8E8F8, 0xFF80B8F8, 0xFFD8E8F8, 0xFF80B8F8, 0xFF80B8F8, 0xFFD8E8F8,
				0xFF969696, 0xFF2D2D2D, 0xFF969696, 0xFF2D2D2D, 0xFF2D2D2D, 0xFF969696
			);
			break;
		}

		// wario stadium
		case 9 : {
			alterDiffuseColor(
				dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
				0xFF283C6E, 0xFF141E38, 0xFF283C6E, 0xFF141E38, 0xFF141E38, 0xFF283C6E,
				0xFFFFE57C, 0xFFFFAE00, 0xFFFFE57C, 0xFFFFAE00, 0xFFFFAE00, 0xFFFFE57C
			);
			break;
		}

		// sherbet land
		case 10 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFFD8E8F8, 0xFF80B8F8, 0xFFD8E8F8, 0xFF80B8F8, 0xFF80B8F8, 0xFFD8E8F8,
					0xFF60CC60, 0xFF004669, 0xFF60CC60, 0xFF004669, 0xFF004669, 0xFF60CC60
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF80B8F8, 0xFFD8E8F8, 0xFF80B8F8, 0xFFD8E8F8, 0xFFD8E8F8, 0xFF80B8F8,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
				);
			break;
		}

		// royal raceway
		//  BAS DROITE, HAUT GAUCHE, BAS GAUCHE, HAUT DROIT, HAUT GAUCHE, BAS DROITE
		case 11 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFFFFE0F0, 0xFFEE90FF, 0xFFFFE0F0, 0xFFEE90FF, 0xFFEE90FF, 0xFFFFE0F0,
					0xFFFF9428, 0xFF870000, 0xFFFF9428, 0xFF870000, 0xFF870000, 0xFFFF9428
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFFFFE0F0, 0xFF000000, 0xFFFFE0F0, 0xFFFFE0F0, 0xFF000000,
					0xFF000000, 0xFFFF9428, 0xFF000000, 0xFFFF9428, 0xFFFF9428, 0xFF000000
				);
			break;
		}

		// bowser castle
		case 12 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF300878, 0xFF000000, 0xFF300878, 0xFF300878, 0xFF000000,
					0xFFAC78FF, 0xFF2670E0, 0xFFAC78FF, 0xFF2670E0, 0xFF2670E0, 0xFFAC78FF
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
					0xFFAC78FF, 0xFFAC78FF, 0xFFAC78FF, 0xFFAC78FF, 0xFFAC78FF, 0xFFAC78FF
				);
			break;
		}

		// DK's jungle parkway
		case 13 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFFFFE57C, 0xFFFFAE00, 0xFFFFE57C, 0xFFFFAE00, 0xFFFFAE00, 0xFFFFE57C,
					0xFF7DA9EC, 0xFF2670E0, 0xFF7DA9EC, 0xFF2670E0, 0xFF2670E0, 0xFF7DA9EC
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF169116, 0xFF000000, 0xFF169116, 0xFF169116, 0xFF000000,
					0xFFFFFFFF, 0xFF7DA9EC, 0xFFFFFFFF, 0xFF7DA9EC, 0xFF7DA9EC, 0xFFFFFFFF
				);
			break;
		}
			
		// yoshi's valley
		case 14 : {
			alterDiffuseColor(
				dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
				0xFFFFB863, 0xFF7146FF, 0xFFFFB863, 0xFF7146FF, 0xFF7146FF, 0xFFFFB863,
				0xFFFFD478, 0xFF96B2FF, 0xFFFFD478, 0xFF96B2FF, 0xFF96B2FF, 0xFFFFD478
			);
			break;
		}
		
		// banshee boardwalk 
		case 15 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
					0xFF280634, 0xFF000947, 0xFF280634, 0xFF000947, 0xFF000947, 0xFF280634
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
					0xFF690015, 0xFF280634, 0xFF690015, 0xFF280634, 0xFF280634, 0xFF690015
				);
			break;
		}

		// rainbow road 
		case 16 : {
			if (isFirstTri(dwV0, dwV1))
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
					0xFF000000, 0xFF000000, rainbow[ i % 1530], rainbow[ (i + 255 + 255) % 1530], rainbow[ (i + 255) % 1530], rainbow[ (i + 255 + 255 + 255) % 1530]
				);
			else
				alterDiffuseColor(
					dwV0, dwV1, dwV2, dwV3, dwV4, dwV5,
					0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
					0xFF000000, 0xFF000000, rainbow[ (i + 255 + 255 + 255 + 255 + 255) % 1530], rainbow[ (i + 255 + 255 + 255) % 1530], rainbow[ i % 1530], rainbow[ (i + 255 + 255 + 255 + 255) % 1530]
				);

			i = i + 2;
			i = i < 0 ? 0 : i;
			break;
		}

	}

}

// /CODE MODIFICATION

void RSP_GBI1_Tri2(Gfx *gfx)
{
	status.primitiveType = PRIM_TRI2;
	bool bTrisAdded = false;
	bool bTexturesAreEnabled = CRender::g_pRender->IsTextureEnabled();

	// While the next command pair is Tri2, add vertices
	uint32 dwPC = gDlistStack[gDlistStackPointer].pc;

	do {
		// Vertex indices are multiplied by 10 for Mario64, by 2 for MarioKart
		uint32 dwV0 = gfx->gbi1tri2.v0/gRSP.vertexMult;
		uint32 dwV1 = gfx->gbi1tri2.v1/gRSP.vertexMult;
		uint32 dwV2 = gfx->gbi1tri2.v2/gRSP.vertexMult;

		uint32 dwV3 = gfx->gbi1tri2.v3/gRSP.vertexMult;
		uint32 dwV4 = gfx->gbi1tri2.v4/gRSP.vertexMult;
		uint32 dwV5 = gfx->gbi1tri2.v5/gRSP.vertexMult;

		// CODE MODIFICATION
	
		// mario kart background (= sky) color hack
		int x1 = (int) (g_vecProjected[dwV0].x*gRSP.vtxXMul+gRSP.vtxXAdd);
		int x2 = (int) (g_vecProjected[dwV1].x*gRSP.vtxXMul+gRSP.vtxXAdd);
		int targetWidth = (int) (windowSetting.uDisplayWidth / 2);


		//bool xWidthIsOk = (x1 - x2) > targetWidth;
		if ( (x1 - x2) > targetWidth )

			//bool x1AtRightPosition = x1 > -ghostPixels && x1 < (windowSetting.uDisplayWidth + ghostPixels) && (x1 % targetWidth) < 3;
			if (x1 > -ghostPixels && x1 < (windowSetting.uDisplayWidth + ghostPixels) && (x1 % targetWidth) < 3)

				//bool x2AtRightPosition = x2 > -ghostPixels && x2 < (windowSetting.uDisplayWidth + ghostPixels) && (x2 % targetWidth) < 3;
				if (x2 > -ghostPixels && x2 < (windowSetting.uDisplayWidth + ghostPixels) && (x2 % targetWidth) < 3)

					//bool isPaintingBackground = xWidthIsOk && x1AtRightPosition && x2AtRightPosition;
					overrideBackground(dwV0, dwV1, dwV2, dwV3, dwV4, dwV5);

		// /CODE MODIFICATION

		// Do first tri
		if (IsTriangleVisible(dwV0, dwV1, dwV2))
		{
			DEBUG_DUMP_VERTEXES("Tri2 1/2", dwV0, dwV1, dwV2);
			if (!bTrisAdded)
			{
				if( bTexturesAreEnabled )
			{
				PrepareTextures();
				InitVertexTextureConstants();
			}
				CRender::g_pRender->SetCombinerAndBlender();
				bTrisAdded = true;
			}
			PrepareTriangle(dwV0, dwV1, dwV2);
		}

		// Do second tri
		if (IsTriangleVisible(dwV3, dwV4, dwV5))
		{
			DEBUG_DUMP_VERTEXES("Tri2 2/2", dwV3, dwV4, dwV5);
			if (!bTrisAdded)
			{
				if( bTexturesAreEnabled )
			{
				PrepareTextures();
				InitVertexTextureConstants();
			}
				CRender::g_pRender->SetCombinerAndBlender();
				bTrisAdded = true;
			}
			PrepareTriangle(dwV3, dwV4, dwV5);
		}

		gfx++;
		dwPC += 8;
#ifdef _DEBUG
	} while (!(pauseAtNext && eventToPause==NEXT_TRIANGLE) && gfx->words.cmd == (uint8)RSP_TRI2);
#else
	} while( gfx->words.cmd == (uint8)RSP_TRI2);
#endif


	gDlistStack[gDlistStackPointer].pc = dwPC-8;


	if (bTrisAdded)	
	{
		CRender::g_pRender->DrawTriangles();
	}

	DEBUG_TRIANGLE(TRACE0("Pause at GBI1 TRI1"));
}

extern D3DXVECTOR4 g_vtxNonTransformed[MAX_VERTS];

void RSP_GBI1_BranchZ(Gfx *gfx)
{
	SP_Timing(RSP_GBI1_BranchZ);

	uint32 vtx = ((gfx->words.w0)&0xFFF)>1;
	float vtxdepth = g_vecProjected[vtx].z/g_vecProjected[vtx].w;

#ifdef _DEBUG
	if( debuggerEnableZBuffer==FALSE || vtxdepth <= (s32)gfx->words.w1 || g_curRomInfo.bForceDepthBuffer )
#else
	if( vtxdepth <= (s32)(gfx->words.w1) || g_curRomInfo.bForceDepthBuffer )
#endif
	{
		uint32 dwPC = gDlistStack[gDlistStackPointer].pc;		// This points to the next instruction
		uint32 dwDL = *(uint32 *)(g_pRDRAMu8 + dwPC-12);
		uint32 dwAddr = RSPSegmentAddr(dwDL);

		dwAddr = RSPSegmentAddr(dwDL);;

		LOG_UCODE("BranchZ to DisplayList 0x%08x", dwAddr);
		gDlistStack[gDlistStackPointer].pc = dwAddr;
		gDlistStack[gDlistStackPointer].countdown = MAX_DL_COUNT;
	}
}

#ifdef _DEBUG
void DumpUcodeInfo(UcodeInfo &info)
{
	DebuggerAppendMsg("Loading Unknown Ucode:\n%08X-%08X-%08X-%08X, Size=0x%X, CRC=0x%08X\nCode:\n",
		info.ucDWORD1, info.ucDWORD2, info.ucDWORD3, info.ucDWORD4, 
		info.ucSize, info.ucCRC);
	DumpHex(info.ucStart,20);
	TRACE0("Data:\n");
	DumpHex(info.ucDStart,20);
}
#endif

void RSP_GBI1_LoadUCode(Gfx *gfx)
{
	SP_Timing(RSP_GBI1_LoadUCode);

	//TRACE0("Load ucode");
	uint32 dwPC = gDlistStack[gDlistStackPointer].pc;
	uint32 dwUcStart = RSPSegmentAddr((gfx->words.w1));
	uint32 dwSize = ((gfx->words.w0)&0xFFFF)+1;
	uint32 dwUcDStart = RSPSegmentAddr(*(uint32 *)(g_pRDRAMu8 + dwPC-12));

	uint32 ucode = DLParser_CheckUcode(dwUcStart, dwUcDStart, dwSize, 8);
	RSP_SetUcode(ucode, dwUcStart, dwUcDStart, dwSize);

	DEBUGGER_PAUSE_AND_DUMP(NEXT_SWITCH_UCODE,{DebuggerAppendMsg("Pause at loading ucode");});
}

void RSP_GFX_Force_Matrix(uint32 dwAddr)
{
	if (dwAddr + 64 > g_dwRamSize)
	{
		DebuggerAppendMsg("ForceMtx: Address invalid (0x%08x)", dwAddr);
		return;
	}

	// Load matrix from dwAddr
	LoadMatrix(dwAddr);

	CRender::g_pRender->SetWorldProjectMatrix(matToLoad);

	DEBUGGER_PAUSE_AND_DUMP(NEXT_MATRIX_CMD,{TRACE0("Paused at ModMatrix Cmd");});
}


void DisplayVertexInfo(uint32 dwAddr, uint32 dwV0, uint32 dwN)
{
#ifdef _DEBUG
		s8 *pcSrc = (s8 *)(g_pRDRAMu8 + dwAddr);
		short *psSrc = (short *)(g_pRDRAMu8 + dwAddr);

		for (uint32 dwV = dwV0; dwV < dwV0 + dwN; dwV++)
		{
			float x = (float)psSrc[0^0x1];
			float y = (float)psSrc[1^0x1];
			float z = (float)psSrc[2^0x1];

			//uint32 wFlags = g_dwVtxFlags[dwV]; //(uint16)psSrc[3^0x1];
			uint32 wFlags = 0;

			uint8 a = pcSrc[12^0x3];
			uint8 b = pcSrc[13^0x3];
			uint8 c = pcSrc[14^0x3];
			uint8 d = pcSrc[15^0x3];
			
			//LONG nTU = (LONG)(short)(psSrc[4^0x1]<<4);
			//LONG nTV = (LONG)(short)(psSrc[5^0x1]<<4);

			//float tu = (float)(nTU>>4);
			//float tv = (float)(nTV>>4);
			float tu = (float)(short)(psSrc[4^0x1]);
			float tv = (float)(short)(psSrc[5^0x1]);

			D3DXVECTOR4 & t = g_vecProjected[dwV];

			psSrc += 8;			// Increase by 16 bytes
			pcSrc += 16;

			LOG_UCODE(" #%02d Flags: 0x%04x Pos: {% 6f,% 6f,% 6f} Tex: {%+7.2f,%+7.2f}, Extra: %02x %02x %02x %02x (transf: {% 6f,% 6f,% 6f})",
				dwV, wFlags, x, y, z, tu, tv, a, b, c, d, t.x, t.y, t.z );
		}
#endif
}

void RSP_MoveMemLight(uint32 dwLight, uint32 dwAddr)
{
	if( dwLight >= 16 )
	{
		DebuggerAppendMsg("Warning: invalid light # = %d", dwLight);
		return;
	}

	s8 * pcBase = g_pRDRAMs8 + dwAddr;
	uint32 * pdwBase = (uint32 *)pcBase;


	float range = 0, x, y, z;
	if( options.enableHackForGames == HACK_FOR_ZELDA_MM && (pdwBase[0]&0xFF) == 0x08 && (pdwBase[1]&0xFF) == 0xFF )
	{
		gRSPn64lights[dwLight].dwRGBA		= pdwBase[0];
		gRSPn64lights[dwLight].dwRGBACopy	= pdwBase[1];
		short* pdwBase16 = (short*)pcBase;
		x		= pdwBase16[5];
		y		= pdwBase16[4];
		z		= pdwBase16[7];
		range	= pdwBase16[6];
	}
	else
	{
		gRSPn64lights[dwLight].dwRGBA		= pdwBase[0];
		gRSPn64lights[dwLight].dwRGBACopy	= pdwBase[1];
		x		= pcBase[8 ^ 0x3];
		y		= pcBase[9 ^ 0x3];
		z		= pcBase[10 ^ 0x3];
	}

					
	LOG_UCODE("       RGBA: 0x%08x, RGBACopy: 0x%08x, x: %d, y: %d, z: %d", 
		gRSPn64lights[dwLight].dwRGBA,
		gRSPn64lights[dwLight].dwRGBACopy,
		x, y, z);

	LIGHT_DUMP(TRACE3("Move Light: %08X, %08X, %08X", pdwBase[0], pdwBase[1], pdwBase[2]));


	if (dwLight == gRSP.ambientLightIndex)
	{
		LOG_UCODE("      (Ambient Light)");

		uint32 dwCol = COLOR_RGBA( (gRSPn64lights[dwLight].dwRGBA >> 24)&0xFF,
					  (gRSPn64lights[dwLight].dwRGBA >> 16)&0xFF,
					  (gRSPn64lights[dwLight].dwRGBA >>  8)&0xFF, 0xff);

		SetAmbientLight( dwCol );
	}
	else
	{
		
		LOG_UCODE("      (Normal Light)");

		SetLightCol(dwLight, gRSPn64lights[dwLight].dwRGBA);
		if (pdwBase[2] == 0)	// Direction is 0!
		{
			LOG_UCODE("      Light is invalid");
		}
		SetLightDirection(dwLight, x, y, z, range);
	}
}

void RSP_MoveMemViewport(uint32 dwAddr)
{
	if( dwAddr+16 >= g_dwRamSize )
	{
		TRACE0("MoveMem Viewport, invalid memory");
		return;
	}

	short scale[4];
	short trans[4];

	// dwAddr is offset into RD_RAM of 8 x 16bits of data...
	scale[0] = *(short *)(g_pRDRAMu8 + ((dwAddr+(0*2))^0x2));
	scale[1] = *(short *)(g_pRDRAMu8 + ((dwAddr+(1*2))^0x2));
	scale[2] = *(short *)(g_pRDRAMu8 + ((dwAddr+(2*2))^0x2));
	scale[3] = *(short *)(g_pRDRAMu8 + ((dwAddr+(3*2))^0x2));

	trans[0] = *(short *)(g_pRDRAMu8 + ((dwAddr+(4*2))^0x2));
	trans[1] = *(short *)(g_pRDRAMu8 + ((dwAddr+(5*2))^0x2));
	trans[2] = *(short *)(g_pRDRAMu8 + ((dwAddr+(6*2))^0x2));
	trans[3] = *(short *)(g_pRDRAMu8 + ((dwAddr+(7*2))^0x2));


	int nCenterX = trans[0]/4;
	int nCenterY = trans[1]/4;
	int nWidth   = scale[0]/4;
	int nHeight  = scale[1]/4;

	// Check for some strange games
	if( nWidth < 0 )	nWidth = -nWidth;
	if( nHeight < 0 )	nHeight = -nHeight;

	int nLeft = nCenterX - nWidth;
	int nTop  = nCenterY - nHeight;
	int nRight= nCenterX + nWidth;
	int nBottom= nCenterY + nHeight;

	//LONG maxZ = scale[2];
	int maxZ = 0x3FF;

	CRender::g_pRender->SetViewport(nLeft, nTop, nRight, nBottom, maxZ);


	LOG_UCODE("        Scale: %d %d %d %d = %d,%d", scale[0], scale[1], scale[2], scale[3], nWidth, nHeight);
	LOG_UCODE("        Trans: %d %d %d %d = %d,%d", trans[0], trans[1], trans[2], trans[3], nCenterX, nCenterY);
}


// S2DEX uses this - 0xc1
void RSP_S2DEX_SPObjLoadTxtr_Ucode1(Gfx *gfx)
{
	SP_Timing(RSP_S2DEX_SPObjLoadTxtr_Ucode1);

	// Add S2DEX ucode supporting to F3DEX, see game DT and others
	status.bUseModifiedUcodeMap = true;
	RSP_SetUcode(1);
	memcpy( &LoadedUcodeMap, &ucodeMap1, sizeof(UcodeMap));
	
	LoadedUcodeMap[S2DEX_OBJ_MOVEMEM] = &RSP_S2DEX_OBJ_MOVEMEM;
	LoadedUcodeMap[S2DEX_OBJ_LOADTXTR] = &RSP_S2DEX_SPObjLoadTxtr;
	LoadedUcodeMap[S2DEX_OBJ_LDTX_SPRITE] = &RSP_S2DEX_SPObjLoadTxSprite;
	LoadedUcodeMap[S2DEX_OBJ_LDTX_RECT] = &RSP_S2DEX_SPObjLoadTxRect;
	LoadedUcodeMap[S2DEX_OBJ_LDTX_RECT_R] = &RSP_S2DEX_SPObjLoadTxRectR;

	RSP_S2DEX_SPObjLoadTxtr(gfx);
}
